//
//  MCOutlineView.h
//  MCViews
//
//  Created by mauricem on Thu Aug 16 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>

#import "MCTableView.h"
#import "MCTableColumnHelperProtocol.h"

@class MCTableColumnHelper;
@protocol MCTableColumnHelperProtocol;
@interface MCOutlineView : NSOutlineView <MCTableColumnHelperProtocol> {

	NSColor		*rowColor;
	NSColor		*alternateColor;

	NSMenu      *columnMenu;

	SEL deleteAction; // if delete is pressed, what should be called?

	unsigned int   _externalDraggingMask;

	// Editing begins after a double-click delay after one click on an already selected row/column, just like in finder and itunes
	BOOL delayedEditMode;
	int delayedEditColumn;
	int delayedEditRow;
	NSEvent *delayedEditEvent;	

	MCTableColumnHelper   *_tableColumnHelper;
	NSMutableArray*        _activeColumns;
	NSMutableArray*        _inactiveColumns;

	MCTableViewGradientStyle gradientStyle;

	BOOL canShowViewOptions;

	id contextualMenuDelegate; // we ask him for contextual menu items
}
- (IBAction)delete:(id)sender;

- (NSMenu *)columnMenu;
- (void)setColumnMenu:(NSMenu *)aMenu;

- (NSColor *)rowColor;
- (void)setRowColor:(NSColor *)aColor;

- (NSColor *)alternateRowColor;
- (void)setAlternateRowColor:(NSColor *)aColor;

- (NSMutableArray *)selectedObjects;
- (void)selectObject: (id)object;

// DELAYED EDIT
- (BOOL)delayedEditMode;
- (void)setDelayedEditMode:(BOOL)flag;

- (NSEvent *)delayedEditEvent;
- (void)setDelayedEditEvent:(NSEvent *)aDelayedEditEvent;

	// gets called after a delayed to start up an edit if delayedEditMode is YES
- (void)delayedEdit;

// EXPAND/COLLAPSE
- (IBAction)expandAllSubItems:(id)sender;
- (IBAction)collapseAllSubItems:(id)sender;


#pragma mark Accessors
// Use these methods to override the draggingSourceOperationForLocal: behaviour of NSTableView
// You cannot set this behaviour on a non subclassed tableview for some dumb reason, now you can!
- (unsigned int)externalDraggingMask;
- (void)setExternalDraggingMask:(unsigned int)anExternalDraggingMask;

- (SEL)deleteAction;
- (void)setDeleteAction:(SEL)aDeleteAction;

- (BOOL)canShowViewOptions;
- (void)setCanShowViewOptions:(BOOL)flag;
- (MCTableColumnHelper *)tableColumnHelper;
- (void)setTableColumnHelper:(MCTableColumnHelper *)aTableColumnHelper;

- (NSMutableArray *)activeColumns;
- (void)setActiveColumns:(NSMutableArray *)anActiveColumns;
- (NSMutableArray *)inactiveColumns;
- (void)setInactiveColumns:(NSMutableArray *)anInactiveColumns;

- (id)contextualMenuDelegate;
- (void)setContextualMenuDelegate:(id)aContextualMenuDelegate;

- (MCTableViewGradientStyle)gradientStyle;
- (void)setGradientStyle:(MCTableViewGradientStyle)aGradientStyle;
@end

@interface NSObject (MCOutlineViewDelegate)
- (void)outlineViewDidChangeColumns:(MCOutlineView *)ov;

@end

@interface NSOutlineView (ShutUpCompiler)
- (id)_highlightColorForCell:(NSCell *)cell;
@end

